﻿namespace Hims.Domain.Helpers
{
    /// <summary>
    /// The CookiesFactory interface.
    /// </summary>
    public interface ICookieHelper
    {
        /// <summary>
        /// The create.
        /// </summary>
        /// <param name="key">
        /// The key.
        /// </param>
        /// <param name="value">
        /// The value.
        /// </param>
        /// <param name="expiryTime">
        /// The expiry time.
        /// </param>
        void Create(string key, string value, int? expiryTime);

        /// <summary>
        /// The get.
        /// </summary>
        /// <param name="key">
        /// The key.
        /// </param>
        /// <returns>
        /// The <see cref="string"/>.
        /// </returns>
        string Get(string key);

        /// <summary>
        /// The remove.
        /// </summary>
        /// <param name="key">
        /// The key.
        /// </param>
        void Remove(string key);

        /// <summary>
        /// The delete all.
        /// </summary>
        /// <param name="key">
        /// The key.
        /// </param>
        void DeleteAll(string key);

        /// <summary>
        /// The delete all.
        /// </summary>
        void DeleteAll();
    }
}