﻿namespace Hims.Domain.Helpers
{
    using System.Threading.Tasks;

    using RestSharp;

    /// <summary>
    /// The salucro interface.
    /// </summary>
    public interface ISalucroHelper
    {
        /// <summary>
        /// The refund async.
        /// </summary>
        /// <param name="processingId">
        /// The payment id.
        /// </param>
        /// <param name="paymode"></param>
        /// <param name="patientName"></param>
        /// <param name="accountNumber"></param>
        /// <param name="amount">
        /// The amount.
        /// </param>
        /// <param name="email"></param>
        /// <param name="transactionId"></param>
        /// <param name="check_sum_hash"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IRestResponse> RefundAsync(string processingId, string paymode, string patientName,string accountNumber,decimal amount,string email,string transactionId,string check_sum_hash);

        /// <summary>
        /// The refund async.
        /// </summary>
        /// <param name="processingId">
        /// The payment id.
        /// </param>
        /// <param name="check_sum_hash"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IRestResponse> StatusCheckAsync(string processingId, string check_sum_hash);
    }
}
