﻿namespace Hims.Domain.Helpers
{
    using System.Threading.Tasks;

    /// <summary>
    /// Renders email content based on razor templates
    /// </summary>
    public interface ITemplateHelper
    {
        /// <summary>
        /// Renders a template given the provided view model
        /// </summary>
        /// <typeparam name="TViewModel">The entity.</typeparam>
        /// <param name="filename">Filename of the template to render</param>
        /// <param name="viewModel">View model to use for rendering the template</param>
        /// <returns>Returns the rendered template content</returns>
        Task<string> RenderTemplateAsync<TViewModel>(string filename, TViewModel viewModel);
    }
}