﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;

    /// <summary>
    /// The DoctorDeviceDetailsService interface.
    /// </summary>
    public interface IDoctorDeviceDetailsService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<DoctorDeviceDetailsModel>> FetchAsync(int appointmentId);

        /// <summary>
        /// The insert async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> InsertAsync(DoctorDeviceDetailsModel model);
    }
}