﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Shared.UserModels.Common;
    using Hims.Shared.UserModels.DynamicDashboard;
    using Hims.Shared.UserModels.DynamicDashboard.Config;
    using Shared.EntityModels;

    /// <summary>
    /// The Appointment Service interface.
    /// </summary>
    public interface IDynamicDashboardService
    {

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<DashboardConfigModel>> FetchAsync(FetchFilterModel model);

        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<GenericResponse> InsertAsync(InsertModel model);

        ///// <summary>
        ///// Updates the asynchronous.
        ///// </summary>
        ///// <param name="model">The model.</param>
        ///// <returns></returns>
        //Task<int> UpdateAsync(DashboardConfigModel model);

        /// <summary>
        /// Deletes the asynchronous.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> DeleteAsync(int id);
    }
}
