﻿namespace Hims.Domain.Services
{
    using Hims.Shared.Library.Helpers;
    using Shared.EntityModels;
    using Shared.Library;
    using Shared.Library.Enums;
    using Shared.UserModels;
    using System.Collections.Generic;
    using System.Threading.Tasks;

    /// <summary>
    /// The emergencyEncounterService interface.
    /// </summary>
    public interface IEmergencyEncounterService
    {
        /// <summary>
        /// Finds the asynchronous.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<EmergencyEncounterModel> FindAsync(int appointmentId, bool isAdmission);
        /// <summary>
        /// Finds the asynchronous.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<IEnumerable<EmergencyEncounterModel>> FindAllAsync(int ProviderId);
        
        /// <summary>
        /// The add internal medicine async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<CommonResponse> AddAsync(EmergencyEncounterModifyModel model);

        /// <summary>
        /// The update alt async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<CommonResponse> UpdateAsync(EmergencyEncounterModifyModel model);

        /// <summary>
        /// Finds the dashboard asynchronous.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="type">The type.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<EmergencyEncounterResource> FindDashboardAsync(int appointmentId, EmergencyEncounterType type, bool isAdmission);

    }
}
