﻿using Hims.Shared.EntityModels;

using System.Collections.Generic;
using System.Threading.Tasks;

namespace Hims.Domain.Services
{
    /// <summary>
    /// The leave type Service interface.
    /// </summary>
    public interface ILeaveTypeService
    {
        /// <summary>
        /// The add leave types async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(EmployeeShiftModel model);

        /// <summary>
        /// The update leave types async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(EmployeeShiftModel model);

        /// <summary>
        /// The change leave types status async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> ChangeStatusAsync(EmployeeShiftModel model);

        /// <summary>
        /// The fetch leave types async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<EmployeeShiftModel>> FetchAsync(EmployeeShiftFilterModel model);
    }
}
