﻿namespace Hims.Domain.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels.ProviderScheduleVisits;

    /// <summary>
    /// The Coupon Service interface.
    /// </summary>
    public interface IProviderScheduleVisitsService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ViewModel>> FetchAsync(FilterModel model);
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        
        Task<IEnumerable<ViewModel>> FetchDoctorVisitsAsync(FilterModel model);
       
        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(InsertModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        /// 
        Task<int> UpdateAsync(InsertModel model);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="visitTypeId">
        /// The specialization id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int visitTypeId);


        /// <summary>
        /// The get provider availability async.
        /// </summary>
        /// <param name="visitTypeId">
        /// The provider id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> FindNameByVisitorId(int visitTypeId);

        Task<int> ModifyStatusAsync(InsertModel model);
        /// The <see cref="Task"/>.
        /// </returns>
        ///  /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ViewModel>> FetchProvidersWithSpecializationAsync(int a);
    }
}
