﻿namespace Hims.Infrastructure.Helpers
{
    using System.Threading.Tasks;

    using Domain.Configurations;

    using RestSharp;

    using Hims.Domain.Helpers;

    /// <summary>
    /// The salucro helper.
    /// </summary>
    public class SalucroHelper : ISalucroHelper
    {
        /// <summary>
        /// The salucro configuration.
        /// </summary>
        private readonly ISalucroConfiguration salucroConfiguration;

        /// <summary>
        /// The client.
        /// </summary>
        private RestClient client;

        /// <summary>
        /// Initializes a new instance of the <see cref="SalucroHelper"/> class.
        /// </summary>
        /// <param name="salucroConfiguration">
        /// The pay u configuration.
        /// </param>
        public SalucroHelper(ISalucroConfiguration salucroConfiguration) => this.salucroConfiguration = salucroConfiguration;

        /// <inheritdoc />
        public Task<IRestResponse> RefundAsync(string processingId, string paymode, string patientName, string accountNumber, decimal amount, string email, string transactionId,string check_sum_hash)
        {
            this.client = new RestClient(this.salucroConfiguration.SalucroAPI);
            var request = new RestRequest("refund", Method.POST);
            var body = new
            {
                processing_id = processingId,
                mid = this.salucroConfiguration.MId,
                auth_user = this.salucroConfiguration.User,
                auth_key = this.salucroConfiguration.Key,
                username = this.salucroConfiguration.UserName,
                check_sum_hash = check_sum_hash,
                paymode = paymode,
                patient_name= patientName,
                account_number= accountNumber,
                amount= amount,
                email= email,
                transaction_id= transactionId
            };
            request.AddJsonBody(body);
            return this.client.ExecuteAsync(request);
        }

        /// <inheritdoc />
        public Task<IRestResponse> StatusCheckAsync(string processingId, string check_sum_hash)
        {
            this.client = new RestClient(this.salucroConfiguration.SalucroAPI);
            var request = new RestRequest("status", Method.POST);
            var body = new
            {
                processing_id = processingId,
                mid = this.salucroConfiguration.MId,
                auth_user = this.salucroConfiguration.User,
                auth_key = this.salucroConfiguration.Key,
                username = this.salucroConfiguration.UserName,
                check_sum_hash = check_sum_hash
            };
            request.AddJsonBody(body);
            return this.client.ExecuteAsync(request);
        }
    }
}
