﻿using Hims.Domain.Services;
using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Infrastructure.Services
{
    using Dapper;
    using Hims.Domain.Repositories.UnitOfWork;
    using Shared.EntityModels;
    using Shared.UserModels.Filters;
    using System.Threading.Tasks;

    public class BedBoardListViewService : IBedBoardListViewService
    {
        private readonly IUnitOfWork unitOfWork;
        public BedBoardListViewService(IUnitOfWork unitOfWork)
        {
            this.unitOfWork = unitOfWork;
        }
        public Task<IEnumerable<ListViewModel>> FetchAsync(ListViewFilterModel model)
        {
            try
            {
                var paramsString = "";

                paramsString += $@" null";

                if (model.ProviderId != null)
                {
                    paramsString += $@", {model.ProviderId}";
                }
                else
                {
                    paramsString += $@", null";
                }

                if (model.PatientId != null)
                {
                    paramsString += $@", {model.PatientId}";
                }
                else
                {
                    paramsString += $@", null";
                }

                if (model.IsDischarged != null)
                {
                    paramsString += $@", {model.IsDischarged}";
                }
                else
                {
                    paramsString += $@", null";
                }

                if (model.PatientMobile != null)
                {
                    paramsString += $@", '{model.PatientMobile}'";
                }
                else
                {
                    paramsString += $@", null";
                }
                paramsString += $@", null";

                paramsString += $@", null";

                if (model.DischargeDate != null)
                {
                    paramsString += $@", '{model.DischargeDate}'";
                }
                else
                {
                    paramsString += $@", null";
                }

                paramsString += $@", null";
                if (model.Active != null)
                {
                    paramsString += $@", '{model.Active}'";
                }
                else
                {
                    paramsString += $@", null";
                }

                paramsString += $@", {model.LocationId}";

                if (model.FloorId != null)
                {
                    paramsString += $@", {model.FloorId}";
                }
                else
                {
                    paramsString += $@", null";
                }

                if (model.WardId != null)
                {
                    paramsString += $@", {model.WardId}";
                }
                else
                {
                    paramsString += $@", null";
                }

                if (model.bedStatusId != null)
                {
                    paramsString += $@", {model.bedStatusId}";
                }
                else
                {
                    paramsString += $@", null";
                }

                model.PageIndex -= 1;
                // var query = $@"select * from ""udf_fetch_Admission1""({paramsString},{model.PageIndex},{model.PageSize})";
                var query = $@"select * from ""udf_fetch_Beds_ListView""({paramsString},{model.PageIndex},{model.PageSize})";

                var result = this.unitOfWork.Current.QueryAsync<ListViewModel>(query);

                return result;
            }
            catch (Exception ex)
            {
                return null;
            }
        }

    }
}
