﻿import { DatePipe } from '@angular/common';
import { APP_INITIALIZER, NgModule } from "@angular/core";
import { BrowserModule } from "@angular/platform-browser";
import { BrowserAnimationsModule } from "@angular/platform-browser/animations";
import { AppComponent } from "@app/app.component";
import { AppRoutingModule, routeGuards, routePages } from "@app/app.routing.module";
import { AvatarImageComponent, SymptomsViewComponent } from "@shared/components";
import { AppConfig, AppData } from "@shared/services";
import { SharedModule } from "@shared/shared.module";
import { OTPWidget } from "@shared/widgets";
import { LayoutComponent } from './areas/layout/layout.component';
import { MastersPage } from './areas/admin/masters/masters.page';
import { CubiclePage } from './areas/admin/masters/pages/cubicle/cubicle.page';

const widgets = [OTPWidget];
const components = [AvatarImageComponent, SymptomsViewComponent];

@NgModule({
    imports: [
        BrowserModule,
        BrowserAnimationsModule,
        SharedModule.forRoot(),
        AppRoutingModule
    ],
    declarations: [
        AppComponent,
        LayoutComponent,
        MastersPage,
        CubiclePage,
        widgets,
        components,
        routePages,
    ],
    providers: [
        AppData,
        AppConfig,
        routeGuards,
        DatePipe,
        {
            provide: APP_INITIALIZER,
            useFactory: (config: AppConfig) => () => config.load(),
            deps: [AppConfig],
            multi: true
        }
    ],
    bootstrap: [AppComponent]
})
export class AppModule {
}