﻿using System;

namespace Hims.Shared.EntityModels
{
    public class BirthCertificateModel
    {
        /// <summary>
        /// Gets or sets the birth certificate id.
        /// </summary>
        public int BirthCertificateId { get; set; }

        /// <summary>
        /// Gets or sets the birth certificate no.
        /// </summary>
        public string BirthCertificateNo { get; set; }

        /// <summary>
        /// Gets or sets the child name.
        /// </summary>
        public string ChildName { get; set; }
        /// <summary>
        /// Gets or sets the date of birth.
        /// </summary>
        public DateTime? DateOfBirth { get; set; }

        public DateTime? BabyDateOfBirth { get; set; }
        /// <summary>
        /// Gets or sets the time of birth.
        /// </summary>
        public string TimeOfBirth { get; set; }
        /// <summary>
        /// Gets or sets the time of birth.
        /// </summary>
        public string BabyTime { get; set; }
        /// <summary>
        /// Gets or sets the sex.
        /// </summary>
        public string Sex { get; set; }
        /// <summary>
        /// Gets or sets the place of birth.
        /// </summary>
        public string PlaceOfBirth { set; get; }
        /// <summary>
        /// Gets or sets the age of mother before marriage.
        /// </summary>
        public int? AgeOfMotherAtMarriage { get; set; }
        /// <summary>
        /// Gets or sets the informants name.
        /// </summary>
        public string InformantsName { get; set; }
        /// <summary>
        /// Gets or sets the informants address.
        /// </summary>
        public string InformantsAddress { get; set; }
        /// <summary>
        /// Gets or sets the patientId.
        /// </summary>
        public int PatientId { get; set; }
        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int AdmissionId { get; set; }
        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
        /// <summary>
        /// Gets or sets the login role id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        public string FatherEducation { get; set; }
        public string FatherOccupation { get; set; }
        public string FatherName { get; set; }
        public string PatientName { get; set; }
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }
        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }
        public string MotherName { get; set; }

        public int PresentMotherAge { get; set; }

        public string State { get; set; }

        public string MotherResidence { get; set; }

        public string Village { get; set; }

        /// <summary>
        /// Gets or sets the id proof id identifier.
        /// </summary>
        /// <value>
        /// The id proof id identifier.
        /// </value>
        public int? OccupationId { get; set; }
        /// <summary>
        /// Gets or sets the occupation detail.
        /// </summary>
        /// <value>
        /// The occupation detail.
        /// </value>
        public string? OccupationDetail { get; set; }

        public string Religion { get; set; }

        public string Babysex { get; set; }
        public string OccupationName { get; set; }
        public string EducationName { get; set; }
        public string StreetAddress { get; set; }
        public string AddressLine2 { get; set; }
        public string City { get; set; }
        public string FatherOccupationDetails { get; set; }
        public int? PatientAge { get; set; }
        public string UMRNo { get; set; }
        public string Mobile { get; set; }
        public string AdmissionNo { get; set; }
        public int? BabyWeight { get; set; }
        public string TypeOfDelivery { get; set; }
        public string MethodOfDelivery { get; set; }
        public string DurationOfPregnancy { get; set; }
        public string NoOfChildBorn { get; set; }
        public string Zipcode { get; set; }
    }
}
