﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The coupon.
    /// </summary>
    public class InsuranceTemplateModel
    {
        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int InsuranceTemplateId { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string TemplateName { get; set; }

        /// <summary>
        /// Gets or sets the floor id.
        /// </summary>
        public int InsuranceCompanyId { get; set; }

        /// <summary>
        /// Gets or sets the floor.
        /// </summary>
        public int TpaId { get; set; }

        /// <summary>
        /// Gets or sets the insurance company name.
        /// </summary>
        public string InsuranceCompanyName { get; set; }

        /// <summary>
        /// Gets or sets the tpa name.
        /// </summary>
        public string TpaName { get; set; }

        /// <summary>
        /// Gets or sets the charge module template id.
        /// </summary>
        public int ChargeModuleTemplateId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or Sets the Modified By Name.
        /// </summary>
        public string? ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the location name.
        /// </summary>
        public string LocationName { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the pay type id.
        /// </summary>
        public int AdmissionPayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the pay type name.
        /// </summary>
        public string? AdmissionPayTypeName { get; set; }
    }
}
