﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary> The lab order value.</summary>
    public class LabOrderValueModel
    {
        /// <summary>
        /// Gets or sets the lab order value id.
        /// </summary>
        public int LabOrderValueId { get; set; }

        /// <summary>
        /// Gets or sets the order code.
        /// </summary>
        public string? OrderCode { get; set; }

        /// <summary>
        /// Gets or sets the code.
        /// </summary>
        public string? Code { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        public string? Name { get; set; }

        /// <summary>
        /// Gets or sets the test.
        /// </summary>
        public string? Test { get; set; }

        /// <summary>
        /// Gets or sets the lab order id.
        /// </summary>
        public int LabOrderId { get; set; }

        /// <summary>
        /// Gets or sets the lab order name.
        /// </summary>
        public string? LabOrderName { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }
    }
}
