﻿#nullable enable
namespace Hims.Shared.UserModels.Filters
{
    /// <summary>
    /// The provider location filter model.
    /// </summary>
    public class ProviderLocationFilterModel
    {
        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int ProviderLocationId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is telemedicine.
        /// </summary>
        public bool IsTelemedicine { get; set; }

        /// <summary>
        /// Gets or sets the visit type.
        /// </summary>
        public string? VisitType { get; set; }

        /// <summary>
        /// Gets or sets the charge type.
        /// </summary>
        public string? ChargeType { get; set; }

        /// <summary>
        /// Gets or sets the timezone.
        /// </summary>
        public string TimeZone { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the slot date.
        /// </summary>
        public string SlotDate { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the offset.
        /// </summary>
        public string Offset { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the encrypted provider id.
        /// </summary>
        public string? EncryptedProviderId { get; set; }

        ///// <summary>
        ///// Gets or sets the visitor id.
        ///// </summary>
        //public int? VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the charge types id.
        /// </summary>
        public int? ChargeTypesId { get; set; }

        /// <summary>
        /// Gets or sets the visit type id.
        /// </summary>
        public int? VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the fetching from.
        /// </summary>
        /// <value>
        /// The fetching from.
        /// </value>
        public string? FetchingFrom { get; set; }

        /// <summary>
        /// Gets or sets the specialization id.
        /// </summary>
        public int SpecializationId { get; set; }
    }
}
