﻿#nullable enable
using System;

namespace Hims.Shared.UserModels.Filters
{
    /// <summary>
    /// The visit type filter model.
    /// </summary>
    public class VisitTypeFilterModel
    {
        /// <summary>
        /// Gets or sets the visitor id.
        /// </summary>
        
        public int VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the visitor name.
        /// </summary>
        public string? VisitorName { get; set; }

        /// <summary>
        /// Gets or sets the visit type for.
        /// </summary>
        public string VisitTypeFor { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }
    }
}
