﻿namespace Hims.Shared.UserModels.Labs
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The lab parameter input model.
    /// </summary>
    public class LabParameterInputModel
    {
        /// <summary>
        /// Gets or sets the lab main detail identifier.
        /// </summary>
        /// <value>
        /// The lab main detail identifier.
        /// </value>
        public int LabMainDetailId { get; set; }

        /// <summary>
        /// Gets or sets the name of the test.
        /// </summary>
        /// <value>
        /// The name of the test.
        /// </value>
        public string TestName { get; set; }

        /// <summary>
        /// Gets or sets the test code.
        /// </summary>
        /// <value>
        /// The test code.
        /// </value>
        public string TestCode { get; set; }

        /// <summary>
        /// Gets or sets the lab department identifier.
        /// </summary>
        /// <value>
        /// The lab department identifier.
        /// </value>
        public int LabDepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the lab sample type identifier.
        /// </summary>
        /// <value>
        /// The lab sample type identifier.
        /// </value>
        public int? LabSampleTypeId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="LabParameterInputModel"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the name of the department.
        /// </summary>
        /// <value>
        /// The name of the department.
        /// </value>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the name of the type.
        /// </summary>
        /// <value>
        /// The name of the type.
        /// </value>
        public string TypeName { get; set; }

        /// <summary>
        /// Gets or sets the templates.
        /// </summary>
        /// <value>
        /// The templates.
        /// </value>
        public List<LabTemplateHeaderForInput> Templates { get; set; }
    }

    /// <summary>
    /// The lab template header for input.
    /// </summary>
    public class LabTemplateHeaderForInput
    {
        /// <summary>
        /// Gets or sets the lab template header identifier.
        /// </summary>
        /// <value>
        /// The lab template header identifier.
        /// </value>        
        public int LabTemplateHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab template observed value identifier.
        /// </summary>
        /// <value>
        /// The lab template observed value identifier.
        /// </value>
        public long? LabTemplateObservedValueId { get; set; }

        /// <summary>
        /// Gets or sets the name of the template.
        /// </summary>
        /// <value>
        /// The name of the template.
        /// </value>
        public string TemplateName { get; set; }

        /// <summary>
        /// Gets or sets the template identifier.
        /// </summary>
        /// <value>
        /// The template identifier.
        /// </value>
        public string TemplateId { get; set; }

        /// <summary>
        /// Gets or sets the is method.
        /// </summary>
        /// <value>
        /// The is method.
        /// </value>
        public bool? IsMethod { get; set; }

        /// <summary>
        /// Gets or sets the method text.
        /// </summary>
        /// <value>
        /// The method text.
        /// </value>
        public string MethodText { get; set; }

        /// <summary>
        /// Gets or sets the is interpretation.
        /// </summary>
        /// <value>
        /// The is interpretation.
        /// </value>
        public bool? IsInterpretation { get; set; }

        /// <summary>
        /// Gets or sets the interpretation text.
        /// </summary>
        /// <value>
        /// The interpretation text.
        /// </value>
        public string InterpretationText { get; set; }

        /// <summary>
        /// Gets or sets the components.
        /// </summary>
        /// <value>
        /// The parameters.
        /// </value>
        public List<LabComponentHeaderForInput> Components { get; set; }

        /// <summary>
        /// Gets or sets the parameters.
        /// </summary>
        /// <value>
        /// The parameters.
        /// </value>
        public List<LabParameterInputHeaderModel> Parameters { get; set; }
    }

    /// <summary>
    /// The lab component header for input.
    /// </summary>
    public class LabComponentHeaderForInput
    {
        /// <summary>
        /// Gets or sets the lab component header identifier.
        /// </summary>
        /// <value>
        /// The lab component header identifier.
        /// </value>
        public int LabComponentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the name of the component.
        /// </summary>
        /// <value>
        /// The name of the component.
        /// </value>
        public string ComponentName { get; set; }

        /// <summary>
        /// Gets or sets the component identifier.
        /// </summary>
        /// <value>
        /// The component identifier.
        /// </value>
        public string ComponentId { get; set; }

        /// <summary>
        /// Gets or sets the parameters.
        /// </summary>
        /// <value>
        /// The parameters.
        /// </value>
        public List<LabParameterInputHeaderModel> Parameters { get; set; }
    }

    /// <summary>
    /// The lab parameter input header model.
    /// </summary>
    public class LabParameterInputHeaderModel
    {
        /// <summary>
        /// Gets or sets the lab parameter header identifier.
        /// </summary>
        /// <value>
        /// The lab parameter header identifier.
        /// </value>		
        public int LabParameterHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the name of the parameter.
        /// </summary>
        /// <value>
        /// The name of the parameter.
        /// </value>
        public string ParameterName { get; set; }

        /// <summary>
        /// Gets or sets the text.
        /// </summary>
        /// <value>
        /// The text.
        /// </value>
        public string Text { get; set; }

        /// <summary>
        /// Gets or sets the display name.
        /// </summary>
        /// <value>
        /// The display name.
        /// </value>
        public string DisplayName { get; set; }

        /// <summary>
        /// Gets or sets the reference output.
        /// </summary>
        /// <value>
        /// The reference output.
        /// </value>
        public string ReferenceOutput { get; set; }


        /// <summary>
        /// Gets or sets the lab parameter method identifier.
        /// </summary>
        /// <value>
        /// The lab parameter method identifier.
        /// </value>
        public int? LabParameterMethodId { get; set; }

        /// <summary>
        /// Gets or sets the name of the method.
        /// </summary>
        /// <value>
        /// The name of the method.
        /// </value>
        public string MethodName { get; set; }

        /// <summary>
        /// Gets or sets the observed value.
        /// </summary>
        /// <value>
        /// The observed value.
        /// </value>
        public string ObservedValue { get; set; }

        /// <summary>
        /// Gets or sets the lab parameter observed value identifier.
        /// </summary>
        /// <value>
        /// The lab parameter observed value identifier.
        /// </value>
        public int? LabParameterObservedValueId { get; set; }

        /// <summary>
        /// Gets or sets all parameter detail.
        /// </summary>
        /// <value>
        /// All parameter detail.
        /// </value>
        public List<LabParameterDetailModel> AllParameterDetail { get; set; }

        /// <summary>
        /// Gets or sets the selected.
        /// </summary>
        /// <value>
        /// The selected.
        /// </value>
        public LabParameterDetailModel Selected { get; set; }

        /// <summary>
        /// Gets or sets the lab parameter detail identifier.
        /// </summary>
        /// <value>
        /// The lab parameter detail identifier.
        /// </value>
        public long? LabParameterDetailId { get; set; }

        /// <summary>
        /// Gets or sets the display order.
        /// </summary>
        /// <value>
        /// The display order.
        /// </value>
        public int? DisplayOrder { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        /// <value>
        /// The active.
        /// </value>
        public bool? Active { get;set; } 
    }

}
