﻿namespace Hims.Shared.UserModels.OperationTheater
{
    using Hims.Shared.EntityModels;
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The ot indent model.
    /// </summary>
    public class OTIndentModel
    {
        /// <summary>
        /// Gets or sets the operation indent header identifier.
        /// </summary>
        /// <value>
        /// The operation indent header identifier.
        /// </value>
        public int OperationIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the indent header identifier.
        /// </summary>
        /// <value>
        /// The indent header identifier.
        /// </value>
        public int IndentHeaderId { get; set; }
        /// <summary>
        /// Gets or sets the indent header identifier.
        /// </summary>
        /// <value>
        /// The indent header identifier.
        /// </value>
        public int? ProductId { get; set; }
        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>
        public int PharmacyWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the approved by.
        /// </summary>
        /// <value>
        /// The approved by.
        /// </value>
        public int? ApprovedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the retail pharmacy identifier.
        /// </summary>
        /// <value>
        /// The retail pharmacy identifier.
        /// </value>
        public int? RetailPharmacyId { get; set; }

        /// <summary>
        /// Gets or sets the approved date.
        /// </summary>
        /// <value>
        /// The approved date.
        /// </value>
        public DateTime? ApprovedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }
        /// <summary>
        /// Gets or sets the RequiredDate date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime RequiredDate { get; set; }

        /// <summary>
        /// Gets or sets the reason.
        /// </summary>
        /// <value>
        /// The reason.
        /// </value>
        public string Reason { get; set; }

        /// <summary>
        /// Gets or sets from.
        /// </summary>
        /// <value>
        /// From.
        /// </value>
        public string From { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by role.
        /// </summary>
        /// <value>
        /// The created by role.
        /// </value>
        public string CreatedByRole { get; set; }

        /// <summary>
        /// Gets or sets the name of the approved by.
        /// </summary>
        /// <value>
        /// The name of the approved by.
        /// </value>
        public string ApprovedByName { get; set; }

        /// <summary>
        /// Gets or sets the approved by role.
        /// </summary>
        /// <value>
        /// The approved by role.
        /// </value>
        public string ApprovedByRole { get; set; }

        /// <summary>
        /// Gets or sets the name of the retail.
        /// </summary>
        /// <value>
        /// The name of the retail.
        /// </value>
        public string RetailName { get; set; }

        /// <summary>
        /// Gets or sets the approved status.
        /// </summary>
        public string ApprovedStatus { get; set; }

        /// <summary>
        /// Gets or sets the approved quantity.
        /// </summary>
        public int ApprovedQuantity { get; set; }

        /// <summary>
        /// Gets or sets the products.
        /// </summary>
        /// <value>
        /// The products.
        /// </value>
        public List<ProductModel> Products { get; set; }

        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        /// <value>
        /// The type.
        /// </value>
        public string Type { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by role.
        /// </summary>
        /// <value>
        /// The modified by role.
        /// </value>
        public string ModifiedByRole { get; set; }

        /// <summary>
        /// Gets or sets the name of the ware house.
        /// </summary>
        /// <value>
        /// The name of the ware house.
        /// </value>
        public string WareHouseNames { get; set; }

        /// <summary>
        /// Gets or sets the ware houose ids.
        /// </summary>
        /// <value>
        /// The ware houose ids.
        /// </value>
        public string WareHouoseIds { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }
        /// <summary>
        /// Gets or sets the FromDate.
        /// </summary>
        /// <value>
        /// FromDate.
        /// </value>
        public string? FromDate { get; set; }
        /// <summary>
        /// Gets or sets the ToDate.
        /// </summary>
        /// <value>
        /// TheToDate.
        /// </value>
        public string? ToDate { get; set; }
        /// <summary>
        /// Gets or sets the Product.
        /// </summary>
        /// <value>
        ///The Product.
        /// </value>
        public string? Product { get; set; }

        /// <summary>
        /// Gets or sets the indent header identifier.
        /// </summary>
        /// <value>
        /// The indent header identifier.
        /// </value>
        public int IssueHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the issuing ware house identifier.
        /// </summary>
        /// <value>
        /// The issuing ware house identifier.
        /// </value>
        public int? IssuingWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the approved ware house.
        /// </summary>
        /// <value>
        /// The approved ware house.
        /// </value>
        public string ApprovedWareHouse { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy department identifier.
        /// </summary>
        /// <value>
        /// The pharmacy department identifier.
        /// </value>
        public int? PharmacyDepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the name of the pharmacy department.
        /// </summary>
        /// <value>
        /// The name of the pharmacy department.
        /// </value>
        public string PharmacyDepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the name of the inventory department.
        /// </summary>
        /// <value>
        /// The name of the inventory department.
        /// </value>
        public string InventoryDepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the inventory department identifier.
        /// </summary>
        /// <value>
        /// The inventory department identifier.
        /// </value>
        public int? InventoryDepartmentId { get; set; }
    }
}
