﻿namespace Hims.Shared.UserModels.Pharmacy
{
    /// <summary>
    /// The drug model.
    /// </summary>
    public class DrugModel
    {
        /// <summary>
        /// Gets or sets the name of the drug.
        /// </summary>
        /// <value>
        /// The name of the drug.
        /// </value>
        public string DrugName { get; set; }

        /// <summary>
        /// Gets or sets the name of the company.
        /// </summary>
        /// <value>
        /// The name of the company.
        /// </value>
        public string CompanyName { get; set; }

        /// <summary>
        /// Gets or sets the packaging of medicines.
        /// </summary>
        /// <value>
        /// The packaging of medicines.
        /// </value>
        public string PackagingOfMedicines { get; set; }

        /// <summary>
        /// Gets or sets the type of the medicine.
        /// </summary>
        /// <value>
        /// The type of the medicine.
        /// </value>
        public string MedicineType { get; set; }

        /// <summary>
        /// Gets or sets the composition.
        /// </summary>
        /// <value>
        /// The composition.
        /// </value>
        public string Composition { get; set; }

        /// <summary>
        /// Gets or sets the alchohol interaction.
        /// </summary>
        /// <value>
        /// The alchohol interaction.
        /// </value>
        public string AlchoholInteraction { get; set; }

        /// <summary>
        /// Gets or sets the pregnancy interaction.
        /// </summary>
        /// <value>
        /// The pregnancy interaction.
        /// </value>
        public string PregnancyInteraction { get; set; }

        /// <summary>
        /// Gets or sets the expert advice.
        /// </summary>
        /// <value>
        /// The expert advice.
        /// </value>
        public string ExpertAdvice { get; set; }

        /// <summary>
        /// Gets or sets the common side effects.
        /// </summary>
        /// <value>
        /// The common side effects.
        /// </value>
        public string CommonSideEffects { get; set; }

        /// <summary>
        /// Gets or sets the medicine FAQ.
        /// </summary>
        /// <value>
        /// The medicine FAQ.
        /// </value>
        public string MedicineFaq { get; set; }

        /// <summary>
        /// Gets or sets the medicine interaction.
        /// </summary>
        /// <value>
        /// The medicine interaction.
        /// </value>
        public string MedicineInteraction { get; set; }

        /// <summary>
        /// Gets or sets the usage.
        /// </summary>
        /// <value>
        /// The usage.
        /// </value>
        public string Usage { get; set; }
    }
}
