﻿
using System;
using System.Collections.Generic;

namespace Hims.Shared.UserModels.ProviderScheduleCharges
{
    /// <summary>
    /// The coupon.
    /// </summary>
    public class InsertModel
    {

        /// <summary>
        /// Gets or sets the provider schedule charge id.
        /// </summary>
        public int ProviderAvailabilityChargeTypeId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the specialization id.
        /// </summary>
        public int? SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the Active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the followup days
        /// </summary>
        public int? FollowUpDays { get; set; }

        /// <summary>
        /// Gets or sets the follow up days limit.
        /// </summary>
        public int? FollowUpDaysLimit { get; set; }

        /// <summary>
        /// Gets or sets the charges.
        /// </summary>
        public List<ProviderAvailabilityCharges> Charges { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string? ModifiedByName { get; set; }

        // <summary>
        /// Gets or sets the parts of day id.
        /// </summary>
        public int? PartsOfDayId { get; set; }


        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }  

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        public string? StartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public string? EndDate { get; set; }

        /// <summary>
        /// Gets or sets the consultation type id.
        /// </summary>
        public int ConsultationTypeId { get; set; }

        public string SchedulerTypeId { get; set; }

    }

    /// <summary>
    /// The duration.
    /// </summary>
    public class ProviderAvailabilityCharges
    {
        /// <summary>
        /// Gets or sets the type id.
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// Gets or sets the value.
        /// </summary>
        public int Value { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the provider availability charge type id.
        /// </summary>
        public int ProviderAvailabilityChargeTypeId { get; set; }
    }

}
