﻿using Hims.Domain.Entities.Enums;

namespace Hims.Shared.UserModels.Receipt
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The receipt model
    /// </summary>
    public class GlobalViewModel
    {
        /// <summary>
        /// Gets or sets the records.
        /// </summary>
        /// <value>
        /// The records.
        /// </value>
        public IEnumerable<ViewModel> Records { get; set; }

        /// <summary>
        /// Gets or sets the sub records.
        /// </summary>
        /// <value>
        /// The sub records.
        /// </value>
        public List<SubViewModel> SubRecords { get; set; }

        /// <summary>
        /// Gets or sets the cost view model.
        /// </summary>
        /// <value>
        /// The cost view model.
        /// </value>
        public CostViewModel CostViewModel { get; set; }
    }
}
