﻿#nullable enable
namespace Hims.Shared.UserModels
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The encounter.
    /// </summary>
    public class ScanTestMasterModel
    {
        /// <summary>
        /// Gets or sets the scan test master id.
        /// </summary>
        public int? ScanTestMasterId { get; set; }

        /// <summary>
        /// Gets or sets the scan test master id.
        /// </summary>
        public int? LocationScanTestMasterMapId { get; set; }

        /// <summary>
        /// Gets or sets the scan test name.
        /// </summary>
        public string ScanTestName { get; set; }

        /// <summary>
        /// Gets or sets the scan test code.
        /// </summary>
        public string ScanTestCode { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// Gets or sets the ScanClassificationName.
        /// </summary>
        public string ScanClassificationName { get; set; }

        /// <summary>
        /// Gets or sets the Scan Sub Classification Name.
        /// </summary>
        public string ScanSubClassificationName { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public decimal Duration { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? ScanClassificationId { get; set; }

        /// <summary>
        /// Gets or sets the Scan Sub Classification Id.
        /// </summary>
        public int? ScanSubClassificationId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string? ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the location ids.
        /// </summary>
        /// <value>
        /// The location ids.
        /// </value>
        public string LocationIds { get; set; }

        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string? LocationNames { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public double Amount { get; set; }

        /// <summary>
        /// Gets or sets the charge category name.
        /// </summary>
        public string ChargeCategoryName { get; set; }

        /// <summary>
        /// Gets or sets the location name.
        /// </summary>
        public string LocationName { get; set; }

        /// <summary>
        /// Gets or sets the Charge Category id.
        /// </summary>
        public int? ChargeCategoryId { get; set; }
        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets test category.
        /// </summary>
        public int? TestCategory { get; set; }

        /// <summary>
        /// Gets or sets test sub category.
        /// </summary>
        public int? TestSubCategory { get; set; }

        /// <summary>
        /// Gets or sets the term.
        /// </summary>
        /// <value>
        /// The term.
        /// </value>
        public string? Term { get; set; }

        /// <summary>
        /// Gets or sets the charges.
        /// </summary>
        /// <value>
        /// The charges.
        /// </value>
        public List<TestChargeModel> Charges { get; set; }

    }

    public class TestChargeModel
    {
        /// <summary>
        /// Gets or sets the scan test master id.
        /// </summary>
        public int ScanTestMasterId { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public double Amount { get; set; }


        /// <summary>
        /// Gets or sets the Charge Category id.
        /// </summary>
        public int ChargeCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the charge category name.
        /// </summary>
        public string ChargeCategoryName { get; set; }
    }
}