﻿using System;
using System.Collections.Generic;

namespace Hims.Shared.UserModels.Vendors
{
    /// <summary>
    /// The product for quotation header.
    /// </summary>
    public class ProductForQuotationHeaderModel
    {
        /// <summary>
        /// Gets or sets the product for quotation header identifier.
        /// </summary>
        /// <value>
        /// The product for quotation header identifier.
        /// </value>
        public long ProductForQuotationHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the quotation number.
        /// </summary>
        /// <value>
        /// The quotation number.
        /// </value>
        public string QuotationNumber { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the tender status identifier.
        /// </summary>
        /// <value>
        /// The tender status identifier.
        /// </value>
        public int TenderStatusId { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the detail.
        /// </summary>
        /// <value>
        /// The detail.
        /// </value>
        public List<ProductForQuotationDetailModel> Detail { get; set; }

        /// <summary>
        /// Gets or sets the require detail.
        /// </summary>
        /// <value>
        /// The require detail.
        /// </value>
        public string RequireDetail { get; set; }

        /// <summary>
        /// Gets or sets the quotation count.
        /// </summary>
        /// <value>
        /// The quotation count.
        /// </value>
        public int QuotationCount { get; set; }
    }

    /// <summary>
    /// The product for quotation detail model.
    /// </summary>
    public class ProductForQuotationDetailModel
    {
        /// <summary>
        /// Gets or sets the product for quotation detail identifier.
        /// </summary>
        /// <value>
        /// The product for quotation detail identifier.
        /// </value>
        public long ProductForQuotationDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product approval identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product approval identifier.
        /// </value>
        public long PharmacyProductApprovalId { get; set; }

        /// <summary>
        /// Gets or sets the product for quotation header identifier.
        /// </summary>
        /// <value>
        /// The product for quotation header identifier.
        /// </value>
        public long ProductForQuotationHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the tender status identifier.
        /// </summary>
        /// <value>
        /// The tender status identifier.
        /// </value>
        public int TenderStatusId { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the name of the generic.
        /// </summary>
        /// <value>
        /// The name of the generic.
        /// </value>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the name of the type.
        /// </summary>
        /// <value>
        /// The name of the type.
        /// </value>
        public string TypeName { get; set; }

        /// <summary>
        /// Gets or sets the name of the sub type.
        /// </summary>
        /// <value>
        /// The name of the sub type.
        /// </value>
        public string SubTypeName { get; set; }

        /// <summary>
        /// Gets or sets the name of the purchase unit.
        /// </summary>
        /// <value>
        /// The name of the purchase unit.
        /// </value>
        public string PurchaseUnitName { get; set; }

        /// <summary>
        /// Gets or sets the name of the sale unit.
        /// </summary>
        /// <value>
        /// The name of the sale unit.
        /// </value>
        public string SaleUnitName { get; set; }

        /// <summary>
        /// Gets or sets the name of the company.
        /// </summary>
        /// <value>
        /// The name of the company.
        /// </value>
        public string CompanyName { get; set; }

        /// <summary>
        /// Gets or sets the name of the category.
        /// </summary>
        /// <value>
        /// The name of the category.
        /// </value>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the purchase unit qty.
        /// </summary>
        /// <value>
        /// The purchase unit qty.
        /// </value>
        public int PurchaseUnitQty { get; set; }

        /// <summary>
        /// Gets or sets the sale unit qty.
        /// </summary>
        /// <value>
        /// The sale unit qty.
        /// </value>
        public int SaleUnitQty { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is general item.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is general item; otherwise, <c>false</c>.
        /// </value>
        public bool IsGeneralItem { get; set; }

        /// <summary>
        /// Gets or sets the tax.
        /// </summary>
        /// <value>
        /// The tax.
        /// </value>
        public int? Tax { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [inventory item].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [inventory item]; otherwise, <c>false</c>.
        /// </value>
        public bool InventoryItem { get; set; }
    }
}
