﻿namespace Hims.Domain.Helpers
{
    using System.Threading.Tasks;

    using RestSharp;

    using Shared.UserModels.PayU;

    /// <summary>
    /// The PayU interface.
    /// </summary>
    public interface IPayUHelper
    {
        /// <summary>
        /// The fetch status async.
        /// </summary>
        /// <param name="merchantTransactionIds">
        /// The merchant transaction ids.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IRestResponse> FetchStatusAsync(string merchantTransactionIds);

        /// <summary>
        /// The refund async.
        /// </summary>
        /// <param name="paymentId">
        /// The payment id.
        /// </param>
        /// <param name="amount">
        /// The amount.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IRestResponse> RefundAsync(long paymentId, decimal amount);

        /// <summary>
        /// The fetch refund status async.
        /// </summary>
        /// <param name="paymentId">
        /// The transaction paymentId.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IRestResponse> FetchRefundStatusAsync(int paymentId);

        /// <summary>
        /// The payout authentication async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IRestResponse> PayoutAuthentication();

        /// <summary>
        /// The payout account details.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IRestResponse> PayoutAccountDetails(PayoutModel model);

        /// <summary>
        /// The payout smart send.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IRestResponse> PayoutSmartSendAsync(PayoutModel model);

        /// <summary>
        /// The payout smart send.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IRestResponse> PayoutPaymentAsync(PayoutModel model);

        /// <summary>
        /// The add web hook.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IRestResponse> AddWebHook(PayoutModel model);

        /// <summary>
        /// The delete web hook.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IRestResponse> DeleteWebHook(PayoutModel model);

        /// <summary>
        /// The add web hook.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IRestResponse> FetchPayoutTransfers(PayoutModel model);
    }
}
