﻿using System;

namespace Hims.Shared.EntityModels
{
    /// <summary>
    /// The role.
    /// </summary>
    public class RoleModel
    {
        /// <summary>
        /// Gets or sets the role id.
        /// </summary>
        public int RoleId { get; set; }

        /// <summary>
        /// Gets or sets the role name.
        /// </summary>
        public string? RoleName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; } 
        
        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        /// 
        public int TotalItems { get; set; }
        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }
        
        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }


        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string? ModifiedByName { get; set; }
        
        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string? FullName { get; set; }
        /// <summary>
        /// Gets or sets the login role identifier.
        /// </summary>
        /// <value>
        /// The login role identifier.
        /// </value>
        public short? LoginRoleId { get; set; }

    }
}
