﻿namespace Hims.Shared.UserModels.FinalBill.ServiceOrder
{
    /// <summary>
    /// The receipt model
    /// </summary>
    public class ViewModel
    {
        /// <summary>
        /// Gets or sets the charge identifier.
        /// </summary>
        /// <value>
        /// The charge identifier.
        /// </value>
        public int? ChargeId { get; set; }

        /// <summary>
        /// Gets or sets the repeat type identifier.
        /// </summary>
        /// <value>
        /// The repeat type identifier.
        /// </value>
        public int RepeatTypeId { get; set; }

        /// <summary>
        /// Gets or sets the product identifier.
        /// </summary>
        /// <value>
        /// The product identifier.
        /// </value>
        public int? ProductId { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        /// <value>
        /// The discount amount.
        /// </value>
        public double? DiscountAmount { get; set; }

        public double? Discount { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        /// <value>
        /// The discount percentage.
        /// </value>
        public double? DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the unit.
        /// </summary>
        /// <value>
        /// The unit.
        /// </value>
        public int Unit { get; set; }

        /// <summary>
        /// Gets or sets the cost.
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double Cost { get; set; }

        /// <summary>
        /// Gets or sets the name of the department.
        /// </summary>
        /// <value>
        /// The name of the department.
        /// </value>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the name of the charge group.
        /// </summary>
        /// <value>
        /// The name of the charge group.
        /// </value>
        public string ChargeGroupName { get; set; }

        /// <summary>
        /// Gets or sets the name of the charge.
        /// </summary>
        /// <value>
        /// The name of the charge.
        /// </value>
        public string ChargeName { get; set; }

        /// <summary>
        /// Gets or sets the name of the special doctor.
        /// </summary>
        /// <value>
        /// The name of the special doctor.
        /// </value>
        public string ChargeTypeMainName { get; set; }

        /// <summary>
        /// Gets or sets the is special doctor.
        /// </summary>
        /// <value>
        /// The is special doctor.
        /// </value>
        public int? ChargeTypeId { get; set; }
    }
}
