﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels.Labs
{
    /// <summary>
    /// The LabReportVerificationModel.
    /// </summary>
    public class LabReportVerificationModel
    {
        /// <summary>
        /// Gets or sets the lab report verification identifier.
        /// </summary>
        /// <value>
        /// The lab report verification identifier.
        /// </value>
        public int? LabReportVerificationId { get; set; }
        /// <summary>
        /// Creates new labbookingdetailid.
        /// </summary>
        /// <value>
        /// The new lab booking detail identifier.
        /// </value>
        public int? NewLabBookingDetailId { get; set; }
        /// <summary>
        /// Gets or sets the approved by.
        /// </summary>
        /// <value>
        /// The approved by.
        /// </value>
        public int[]? ApprovedBy { get; set; }
        /// <summary>
        /// Gets or sets the approved date.
        /// </summary>
        /// <value>
        /// The approved date.
        /// </value>
        public DateTime? ApprovedDate { get; set; }
        /// <summary>
        /// Gets or sets the approved.
        /// </summary>
        /// <value>
        /// The approved.
        /// </value>
        public bool? Approved { get; set; }
        /// <summary>
        /// Gets or sets the department identifier.
        /// </summary>
        /// <value>
        /// The department identifier.
        /// </value>
        public int? DepartmentId { get; set; }
        /// <summary>
        /// Gets or sets the location ids.
        /// </summary>
        /// <value>
        /// The location ids.
        /// </value>
        public int[]? LocationIds { get; set; }
        /// <summary>
        /// Gets or sets the provider location identifier.
        /// </summary>
        /// <value>
        /// The provider location identifier.
        /// </value>
        public int? ProviderLocationId { get; set; }
        /// <summary>
        /// Gets or sets the specialization identifier.
        /// </summary>
        /// <value>
        /// The specialization identifier.
        /// </value>
        public int? SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the name of the test.
        /// </summary>
        /// <value>
        /// The name of the test.
        /// </value>
        public string TestName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }
    }

    /// <summary>
    /// The ProviderIds.
    /// </summary>
    public class ProviderIds
    {
        /// <summary>
        /// Gets or sets the provider identifier.
        /// </summary>
        /// <value>
        /// The provider identifier.
        /// </value>
        public int ApprovedBy { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="ProviderIds"/> is approved.
        /// </summary>
        /// <value>
        ///   <c>true</c> if approved; otherwise, <c>false</c>.
        /// </value>
        public bool Approved { get; set; }

        /// <summary>
        /// Gets or sets the name of the provider.
        /// </summary>
        /// <value>
        /// The name of the provider.
        /// </value>
        public string ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the lab report verfication identifier.
        /// </summary>
        /// <value>
        /// The lab report verfication identifier.
        /// </value>
        public int? LabReportVerificationId { get; set; }

    }
}
