﻿namespace Hims.Shared.UserModels.PediatricGraphs
{
    using System;

    /// <summary>
    /// The pediatric age wise data model z score.
    /// </summary>
    public class PediatricAgeWiseDataZScoreModel
    {
        /// <summary>
        /// Gets or sets the pediatric age wise data identifier.
        /// </summary>
        /// <value>
        /// The pediatric age wise data identifier.
        /// </value>
        public int PediatricAgeWiseDataId { get; set; }

        /// <summary>
        /// Gets or sets the pediatric chart authority identifier.
        /// </summary>
        /// <value>
        /// The pediatric chart authority identifier.
        /// </value>
        public int? PediatricChartAuthorityId { get; set; }

        /// <summary>
        /// Gets or sets the pediatric chart type identifier.
        /// </summary>
        /// <value>
        /// The pediatric chart type identifier.
        /// </value>
        public int? PediatricChartTypeId { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        /// <value>
        /// The gender.
        /// </value>
        public string Gender { get; set; }

        /// <summary>
        /// Gets or sets the age in month.
        /// </summary>
        /// <value>
        /// The age in month.
        /// </value>
        public int AgeInMonth { get; set; }
        
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the name of the authority.
        /// </summary>
        /// <value>
        /// The name of the authority.
        /// </value>
        public string AuthorityName { get; set; }

        /// <summary>
        /// Gets or sets the name of the type.
        /// </summary>
        /// <value>
        /// The name of the type.
        /// </value>
        public string TypeName { get; set; }

        /// <summary>
        /// Gets or sets the l.
        /// </summary>
        /// <value>
        /// The l.
        /// </value>
        public double? L { get; set; }

        /// <summary>
        /// Gets or sets the m.
        /// </summary>
        /// <value>
        /// The m.
        /// </value>
        public double? M { get; set; }

        /// <summary>
        /// Gets or sets the sd.
        /// </summary>
        /// <value>
        /// The sd.
        /// </value>
        public double? SD { get; set; }

        /// <summary>
        /// Gets or sets the s.
        /// </summary>
        /// <value>
        /// The s.
        /// </value>
        public double? S { get; set; }

        /// <summary>
        /// Gets or sets the minus3 sd.
        /// </summary>
        /// <value>
        /// The minus3 sd.
        /// </value>
        public double? Minus3SD { get; set; }

        /// <summary>
        /// Gets or sets the minus2 sd.
        /// </summary>
        /// <value>
        /// The minus2 sd.
        /// </value>
        public double? Minus2SD { get; set; }

        /// <summary>
        /// Gets or sets the minus1 sd.
        /// </summary>
        /// <value>
        /// The minus1 sd.
        /// </value>
        public double? Minus1SD { get; set; }

        /// <summary>
        /// Gets or sets the median.
        /// </summary>
        /// <value>
        /// The median.
        /// </value>
        public double? Median { get; set; }


        /// <summary>
        /// Gets or sets the one sd.
        /// </summary>
        /// <value>
        /// The one sd.
        /// </value>
        public double? OneSD { get; set; }

        /// <summary>
        /// Gets or sets the two sd.
        /// </summary>
        /// <value>
        /// The two sd.
        /// </value>
        public double? TwoSD { get; set; }

        /// <summary>
        /// Gets or sets the three sd.
        /// </summary>
        /// <value>
        /// The three sd.
        /// </value>
        public double? ThreeSD { get; set; }
    }
}
