﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels.Pharmacy
{
    /// <summary>
    /// The patient sale bill.
    /// </summary>
    public class PatienSaleBill1
    {

        /// <summary>
        /// Gets or sets the pharmacy sale header id.
        /// </summary>
        public int? PharmacySaleHeaderId { get; set; }
        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }
        /// <summary>
        /// Gets or sets the Payment  type.
        /// </summary>
        public string PaidVia { get; set; }
        /// <summary>
        /// Gets or sets the payment number.
        /// </summary>
        public string PaymentNumber { get; set; }
        /// <summary>
        /// Gets or sets the sale date
        /// </summary>

        public DateTime SaleDate { get; set; }
        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }
        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; }
        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string UMRNo { get; set; }
        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }
        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string ProviderName { get; set; }
        /// <summary>
        /// Gets or sets the created by name
        /// </summary>
        public string CreatedByName { get; set; }
        /// <summary>
        /// Gets or sets the role.
        /// </summary>
        public string Role { get; set; }
        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int AccountId { get; set; }
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public string? CreatedBy { get; set; }
        /// <summary>
        /// Gets or sets the total amount.
        /// </summary>
        public double TotalAmount { get; set; }
        /// <summary>
        /// Gets or sets the pharmacy bill type.
        /// </summary>
        public bool PharmacyBillType { get; set; }
        /// <summary>
        /// Gets or sets the sale return header id.
        /// </summary>
        public string SaleReturnHeaderId { get; set; }
        /// <summary>
        /// Gets or sets the total gst.
        /// </summary>
        public double TotalGST { get; set; }
        /// <summary>
        /// Gets or sets the retail name.
        /// </summary>
        public string RetailName { get; set; }
        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }
        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }
    }
}
