﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The pharmacyLog.
    /// </summary>
    public class DynamicReport
    {
        /// <summary>
        /// Gets or sets the dynamicreport id.
        /// </summary>
        [Key, Identity]
        public int DynamicReportId { get; set; }

        /// <summary>
        /// Gets or sets the AliseName for Query.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the Query.
        /// </summary>
        public string Data { get; set; } 

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the active status.
        /// </summary>
        public bool Active { get; set; }
    }
}