﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The coupon.
    /// </summary>
    public class ProgressReportVitals
    {
        /// <summary>
        /// Gets or sets the progress report vitals id.
        /// </summary>
        [Key, Identity]
        public int ProgressReportVitalsId { get; set; }

        /// <summary>
        /// Gets or sets the progress report id.
        /// </summary>
        public int ProgressReportId { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public DateTime? Date { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int? VitalTypeId { get; set; }


        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int VitalTypeValue { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the vitals.
        /// </summary>
        public string? Vitals { get; set; }

        /// <summary>
        /// Gets or sets the unit name.
        /// </summary>
        public string? UnitName { get; set; }

    }
}
