﻿using Hims.Shared.EntityModels;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Hims.Domain.Services
{
    /// <summary>
    /// The IPaymentMapHelperService.
    /// </summary>
    public interface IPaymentMapHelperService
    {
        /// <summary>
        /// Finds the asynchronous.
        /// </summary>
        /// <param name="PaymentInitiationLogId">The payment initiation log identifier.</param>
        /// <returns></returns>
        Task<PaymentMapHelperModel> FindAsync(int PaymentInitiationLogId);

        /// <summary>
        /// Adds the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AddAsync(PaymentMapHelperModel model);
    }
}
