﻿import { NgModule } from "@angular/core";
import { AvailableDaysComponent, FullScreenComponent, IdleComponent, NoDataComponent, ProgressBarModalComponent, SessionTimeoutComponent } from "@shared/components";
import { AllowNumericDirective, AlphaNumericOnlyDirective, AutoResizeDirective, AutofocusDirective, AvatarBgDirective, BlockCopyPasteDirective, DecimalsOnlyDirective, MenuButtonDirective, NumbersOnlyDirective, NumericDirective, PasswordDirective, PasteOnlyDirective, TextOnlyDirective, TitleOnlyDirective, TrimSpaceDirective, TrueFalseValueDirective } from "@shared/directives";
import { AgePipe, FormatBytesPipe, FromArrayPipe, GenderPipe, InitialsPipe, MaritalStatusPipe, MinuteSecondsPipe, SafePipe, SearchPipe, SortFormArrayPipe, SortFormPipe, TitlePipe, ToArrayPipe, UTCToLocalPipe } from "@shared/pipes";

const components = [SessionTimeoutComponent, NoDataComponent, FullScreenComponent, IdleComponent, ProgressBarModalComponent, AvailableDaysComponent];
const directives = [AlphaNumericOnlyDirective, AutofocusDirective, BlockCopyPasteDirective, DecimalsOnlyDirective, NumericDirective, AvatarBgDirective, NumbersOnlyDirective, PasswordDirective, TextOnlyDirective, TitleOnlyDirective, AutoResizeDirective, PasteOnlyDirective, TrueFalseValueDirective, TrimSpaceDirective, AllowNumericDirective, MenuButtonDirective];
const pipes = [SafePipe, InitialsPipe, TitlePipe, FormatBytesPipe, UTCToLocalPipe, SortFormArrayPipe, GenderPipe, MaritalStatusPipe, FromArrayPipe, ToArrayPipe, MinuteSecondsPipe, SearchPipe, SortFormPipe, AgePipe];

@NgModule({
    declarations: [components, directives, pipes],
    exports: [components, directives, pipes]
})
export class SharedLibsModule {
}