﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The coupon.
    /// </summary>
    public class BedManagementModel
    {
        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int BedId { get; set; }

        /// <summary>
        /// Gets or sets the Rooom id.
        /// </summary>
        /// 
        public int RoomId { get; set; }
        /// Gets or sets the beds count in a room.
        /// </summary>
        public decimal BedsCount { get; set; }
        /// <summary>
        /// Gets or sets the ward id.
        /// </summary>
        public int? WardId { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string BedNumber { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int BedStatusId { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string WardName { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string RoomName { get; set; }

        /// <summary>
        /// Gets or sets the name of the floor.
        /// </summary>
        /// <value>
        /// The name of the floor.
        /// </value>
        public string FloorName { get; set; }

        /// <summary>
        /// Gets or sets the Room rent.
        /// </summary>
        public decimal RoomRent { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int NoOfRooms { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int NoOfBeds { get; set; }
        /// <summary>
        /// Gets or sets the available beds.
        /// </summary>
        public int BookedBed { get; set; }
        /// <summary>
        /// Gets or sets the available beds.
        /// </summary>
        public int AvailableBeds { get; set; }


        /// <summary>
        /// Gets or sets the bed status name.
        /// </summary>
        public string BedStatusName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        /// <value>
        /// The full name.
        /// </value>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the thumbnail URL.
        /// </summary>
        /// <value>
        /// The thumbnail URL.
        /// </value>
        public string ThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the unique identifier.
        /// </summary>
        /// <value>
        /// The unique identifier.
        /// </value>
        public string Guid { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        /// <value>
        /// The gender.
        /// </value>
        public string Gender { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        /// <value>
        /// The age.
        /// </value>
        public int? Age { get; set; }

        /// <summary>
        /// Gets or sets the provider identifier.
        /// </summary>
        /// <value>
        /// The provider identifier.
        /// </value>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the provider consultation room identifier.
        /// </summary>
        /// <value>
        /// The provider consultation room identifier.
        /// </value>
        public int? ProviderConsultationRoomId { get; set; }

        /// <summary>
        /// Gets or sets the charge categoryId.
        /// </summary>
        /// <value>
        /// The charge categoryId.
        /// </value>
        public int? ChargeCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the locationId.
        /// </summary>
        /// <value>
        /// The charge locationId.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the modules master identifier.
        /// </summary>
        /// <value>
        /// The modules master identifier.
        /// </value>
        public int? ModulesMasterId { get; set; }

        /// <summary>
        /// Gets or sets the charge module template identifier.
        /// </summary>
        /// <value>
        /// The charge module template identifier.
        /// </value>
        public int? ChargeModuleTemplateId { get; set; }

        /// <summary>
        /// Gets or sets the charge category name.
        /// </summary>
        public string? ChargeCategoryName { get; set; }
    }
}
