﻿namespace Hims.Shared.EntityModels
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The appointment.
    /// </summary>
    public class NewPatientAdmissionModel
    {
        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted admission id.
        /// </summary>
        public string EncryptedAdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the discharge id.
        /// </summary>
        public int? DischargeId { get; set; }

        /// <summary>
        /// Gets or sets the admission no.
        /// </summary>
        public string AdmissionNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the admission date.
        /// </summary>
        public DateTime AdmissionDate { get; set; }

        /// <summary>
        /// Gets or sets the admission time.
        /// </summary>
        public TimeSpan? AdmissionTime { get; set; }

        /// <summary>
        /// Gets or sets the admission time string.
        /// </summary>
        public string AdmissionTimeString { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the provider gender.
        /// </summary>
        public string ProviderGender { get; set; }

        /// <summary>
        /// Gets or sets the provider age.
        /// </summary>
        public int ProviderAge { get; set; }

        /// <summary>
        /// Gets or sets the provider thumbnail url.
        /// </summary>
        public string? ProviderThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the department id.
        /// </summary>
        public int DepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the department name.
        /// </summary>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted patient id.
        /// </summary>
        public string EncryptedPatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient family member name.
        /// </summary>
        public string? FamilyMemberName { get; set; }

        /// <summary>
        /// Gets or sets the patient relation with family member.
        /// </summary>
        public string? Relation { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient gender.
        /// </summary>
        public string PatientGender { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the patient age.
        /// </summary>
        public int PatientAge { get; set; }

        /// <summary>
        /// Gets or sets the patient thumbnail url.
        /// </summary>
        public string? PatientThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the patient type.
        /// </summary>
        public char? PatientType { get; set; }

        /// <summary>
        /// Gets or sets the ward id.
        /// </summary>
        public int? WardId { get; set; }

        /// <summary>
        /// Gets or sets the room id.
        /// </summary>
        public int? RoomId { get; set; }

        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int? BedId { get; set; }

        /// <summary>
        /// Gets or sets the ward name.
        /// </summary>
        public string WardName { get; set; }

        /// <summary>
        /// Gets or sets the room name.
        /// </summary>
        public string RoomName { get; set; }

        /// <summary>
        /// Gets or sets the bed number.
        /// </summary>
        public string BedNumber { get; set; }

        /// <summary>
        /// Gets or sets the patient family id.
        /// </summary>
        public int? PatientFamilyId { get; set; }

        /// <summary>
        /// Gets or sets the is discharged.
        /// </summary>
        public bool? IsDischarged { get; set; }

        /// <summary>
        /// Gets or sets the is maternity.
        /// </summary>
        public bool? IsMaternity { get; set; }

        /// <summary>
        /// Gets or sets the babys birth date.
        /// </summary>
        public DateTime? BabysBirthDate { get; set; }

        /// <summary>
        /// Gets or sets the babys birth time.
        /// </summary>
        public TimeSpan? BabysBirthTime { get; set; }

        /// <summary>
        /// Gets or sets the babys surgery type.
        /// </summary>
        public int? BabysSurgeryType { get; set; }

        /// <summary>
        /// Gets or sets the babys gender.
        /// </summary>
        public char? BabysGender { get; set; }

        /// <summary>
        /// Gets or sets the babys fathers name.
        /// </summary>
        public string BabysFathersName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the babys fathers name.
        /// </summary>
        public string BabysMothersAdmissionNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the encounter id.
        /// </summary>
        public int? EncounterId { get; set; }

        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public string? EncounterType { get; set; }

        /// <summary>
        /// Gets or sets the ready for discharge.
        /// </summary>
        public bool? ReadyforDischarge { get; set; }

        /// <summary>
        /// Gets or sets the admission notes.
        /// </summary>
        public string? AdmissionNotes { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by role name.
        /// </summary>
        public string CreatedByRoleName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by role name.
        /// </summary>
        public string ModifiedByRoleName { get; set; }

        /// <summary>
        /// Gets or sets the surgery type id.
        /// </summary>
        public int? SurgeryTypeId { get; set; }

        /// <summary>
        /// Gets or sets the surgery name.
        /// </summary>
        public string SurgeryName { get; set; }

        /// <summary>
        /// Gets or sets the attendant name
        /// </summary>
        public string? AttendantName { get; set; }

        /// <summary>
        /// Gets or sets the attendant contact no
        /// </summary>
        public string? AttendantContactNo { get; set; }

        /// <summary>
        /// Gets or sets the attendant relation with patient
        /// </summary>
        public string? AttendantRelationWithPatient { get; set; }

        /// <summary>
        /// Gets or sets the discharge date.
        /// </summary>
        public DateTime? DischargeDate { get; set; }

        /// <summary>
        /// Gets or sets the discharge time.
        /// </summary>
        public TimeSpan? DischargeTime { get; set; }

        /// <summary>
        /// Gets or sets the discharge time string.
        /// </summary>
        public string DischargeTimeString { get; set; }

        /// <summary>
        /// Gets or sets the discharge status.
        /// </summary>
        public string DischargeStatus { get; set; }

        /// <summary>
        /// Gets or sets the paid amount.
        /// </summary>
        public decimal? PaidAmount { get; set; }

        /// <summary>
        /// Gets or sets the final amount.
        /// </summary>
        public decimal? FinalAmount { get; set; }

        /// <summary>
        /// Gets or sets the payment status.
        /// </summary>
        public string? PaymentStatus { get; set; }

        /// <summary>
        /// Gets or sets the is final bill.
        /// </summary>
        public bool? IsFinalBill { get; set; }

        /// <summary>
        /// Gets or sets the Log From.
        /// </summary>
        public short LogFrom { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public short TotalItems { get; set; }


        /// <summary>
        /// Gets or sets the first name.
        /// </summary>
        public string FirstName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the middle name.
        /// </summary>
        public string? MiddleName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the last name.
        /// </summary>
        public string LastName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the father or husband.
        /// </summary>
        public string FatherOrHusband { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string? FullName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        public string? Salutation { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the aadhar no.
        /// </summary>
        public string AadharNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the date of birth.
        /// </summary>
        public DateTime? DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        public short? Age { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public char? Gender { get; set; }

        /// <summary>
        /// Gets or sets the umr.
        /// </summary>
        public string UMRNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public string? Email { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string? Mobile { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int? CountryId { get; set; }

        /// <summary>
        /// Gets or sets the profile image url.
        /// </summary>
        public string? ProfileImageUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the thumbnail url.
        /// </summary>
        public string? ThumbnailUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the base 64 profile image.
        /// </summary>
        public string? Base64ProfileImage { get; set; }

        /// <summary>
        /// Gets or sets the street address.
        /// </summary>
        public string? StreetAddress { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the address line 2.
        /// </summary>
        public string? AddressLine2 { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the city.
        /// </summary>
        public string? City { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the state.
        /// </summary>
        public string? State { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the Zipcode.
        /// </summary>
        public string? Zipcode { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the country name.
        /// </summary>
        public string? CountryName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the country code.
        /// </summary>
        public string? CountryCode { get; set; } = string.Empty;
        /// <summary>
        /// Gets or sets the Referred by.
        /// </summary>
        public string? ReferredBy { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? ReferredByName { get; set; }

        /// <summary>
        /// Gets or sets the visit type id.
        /// </summary>
        public int? VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the is converted from op to ip.
        /// </summary>
        public bool? IsConvertedFromOPtoIp { get; set; }

        /// <summary>
        /// Gets or sets the education.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public string Education { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string Occupation { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string MaritalStatus { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string Religion { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string Nationality { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string RelationName { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string RelativeMobile { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string RelativeOccupation { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string RealtiveEducation { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string RelativeDateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public char? RelativeGender { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        // public string Relation { get; set; }

        /// <summary>
        /// Gets or sets the emergency contacts.
        /// </summary>
        public List<PatientEmergencyModel>? EmergencyContacts { get; set; }

        /// <summary>
        /// Gets or sets the insurances.
        /// </summary>
        public List<PatientInsuranceModel>? Insurances { get; set; }

        /// <summary>
        /// Gets or sets the relative details.
        /// </summary>
        public List<PatientFamilyModel>? RelativeDetails { get; set; }
        public string EmergencyNo { get; set; }
        public string EmergencyType { get; set; }
       
    }
}
