﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.EntityModels
{
    public class PediatricEncounterModel
    {
        /// <summary>
        /// Gets or Sets the ivf Encounter
        /// </summary>
        public int PediatricEncounterId { get; set; }
        /// <summary>
        /// Gets or Sets the appointment id
        /// </summary>
        public int? AppointmentId { get; set; }
        /// <summary>
        /// Gets or Sets the patient id
        /// </summary>
        public int PatientId { get; set; }
        /// <summary>
        /// Gets or Sets the ivf encounter date
        /// </summary>
        public DateTime PediatricEncounterDate { get; set; }
        /// <summary>
        /// Gets or Sets the active
        /// </summary>
        public bool Active { get; set; }
        /// <summary>
        /// Gets or Sets the created by
        /// </summary>
        public int CreatedBy { get; set; }
        /// <summary>
        /// Gets or Sets the created date
        /// </summary>
        public DateTime CreatedDate { get; set; }
        /// <summary>
        /// Gets or Sets the modified by
        /// </summary>
        public int ModifiedBy { get; set; }
        /// <summary>
        /// Gets or Sets the modified date
        /// </summary>
        public DateTime ModifiedDate { get; set; }
        /// <summary>
        /// Gets or Sets the admission id
        /// </summary>
        public int? AdmissionId { get; set; }
        /// <summary>
        /// Gets or Sets the measurements
        /// </summary>
        public string? Measurements { get; set; }
        /// <summary>
        /// Gets or Sets the NeonatalRisk
        /// </summary>
        public string? NeonatalRisk{ get; set; }
        /// <summary>
        /// Gets or Sets the PediatricRisk 
        /// </summary>
       public string? PediatricRisk { get; set; }
        /// <summary>
        /// Gets or Sets the Syndrome
        /// </summary>
        public string? Syndrome { get; set; }

        /// <summary>
        /// Gets or Sets the Clinical Examination
        /// </summary>
        /// 
        public string? ClinicalExamination { get; set; }
        /// <summary>
        /// Gets or Sets the Down Syndrome Follow Up
        /// </summary>
      

        public string? DownSyndromeFollowUp { get; set; }
        /// <summary>
        /// Gets or Sets the HighRiskIntial
        /// </summary>
        public string? HighRiskIntial { get; set; }

        /// <summary>
        /// Gets or Sets the Pediatric Guide
        /// </summary>
        public string? PediatricGuide { get; set; }
        /// <summary>
        /// Gets or Sets the Orders Prescription
        /// </summary>
        public string? OrderPrescription { get; set; }
        /// <summary>
        /// Gets or Sets the Allergies
        /// </summary>
        public string? Allergies { get; set; }
        /// <summary>
        /// Gets or Sets the Allergies
        /// </summary>
        public string? RefferalOrder { get; set; }

        /// <summary>
        /// Gets or sets the vaccine detail.
        /// </summary>
        /// <value>
        /// The vaccine detail.
        /// </value>
        public string? VaccineDetail { get; set; }
        /// <summary>
        /// Gets or Sets the MChat
        /// </summary>
        public string? MChat { get; set; }
        /// <summary>
        /// Gets or Sets the diagnosis order
        /// </summary>
        public string? DiagnosisOrder { get; set; }
        /// <summary>
        /// Gets or Sets the next visit order
        /// </summary>
        public string? NextVisitOrder { get; set; }
        /// <summary>
        /// Gets or Sets the special features.
        /// </summary>
        public string? SpecialFeatures { get; set; }
        /// <summary>
        /// Gets or Sets the family history.
        /// </summary>
        public string? FamilyHistory { get; set; }
        /// <summary>
        /// Gets or Sets the birth history.
        /// </summary>
        public string? BirthHistory{ get; set; }
        /// <summary>
        /// Gets or Sets the MeasureCommonData.
        /// </summary>
        public string? MeasureCommonData { get; set; }
        /// <summary>
        /// Gets or Sets the MeasureCommonData.
        /// </summary>
        public string? Reminder { get; set; }
    }
}
