﻿namespace Hims.Shared.UserModels.ChargeManagement
{
    using System;

    /// <summary>
    /// The provider profile info model.
    /// </summary>
    public class MastersViewModel
    {
        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public int DepartmentId { get; set; }
        /// <summary>
        /// Gets or sets the name of the department.
        /// </summary>
        /// <value>
        /// The name of the department.
        /// </value>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the charge group identifier.
        /// </summary>
        /// <value>
        /// The charge group identifier.
        /// </value>
        public int ChargeGroupId { get; set; }

        /// <summary>
        /// Gets or sets the name of the charge group.
        /// </summary>
        /// <value>
        /// The name of the charge group.
        /// </value>
        public string ChargeGroupName { get; set; }

        /// <summary>
        /// Gets or sets the charge identifier.
        /// </summary>
        /// <value>
        /// The charge identifier.
        /// </value>
        public int ChargeId { get; set; }

        /// <summary>
        /// Gets or sets the name of the charge.
        /// </summary>
        /// <value>
        /// The name of the charge.
        /// </value>
        public string ChargeName { get; set; }
    }
}