﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Shared.UserModels
{

    /// <summary>
    /// The dynamic template config
    /// </summary>
    public class DynamicTemplateConfigModel
    {

        /// <summary>
        /// Gets or sets the dynamic template config identifier.
        /// </summary>
        /// <value>
        /// The dynamic template config identifier.
        /// </value>
        [Key, Identity]
        public int DynamicTemplateConfigId { get; set; }

        /// <summary>
        /// Gets or sets the name of report.
        /// </summary>
        /// <value>
        /// The name of report.
        /// </value>
        public string ReportName { get; set; }
        /// <summary>
        /// Gets or sets the dynamic report identifier.
        /// </summary>
        /// <value>
        /// The dynamic report identifier.
        /// </value>
        public int DynamicReportId { get; set; }
        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }
        /// <summary>
        /// Gets or sets the login role id.
        /// </summary>
        /// <value>
        /// The login role id.
        /// </value>
        public int? LoginRoleId { get; set; }
        /// <summary>
        /// Gets or sets the created by name..
        /// </summary>
        /// <value>
        /// The created by name.
        /// </value>
        public string? CreatedByName { get; set; }
        /// <summary>
        /// Gets or sets the template name.
        /// </summary>
        /// <value>
        /// The template name.
        /// </value>
        public string? TemplateName { get; set; }
        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        /// <value>
        /// The modified by name.
        /// </value>
        public string? ModifiedByName { get; set; }
    }
}
