﻿namespace Hims.Shared.UserModels.Inventory
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The purchase bill header model.
    /// </summary>
    public class InventoryBillHeaderModel
    {
        /// <summary>
        /// Gets or sets the bill amount.
        /// </summary>
        /// <value>
        /// The bill amount.
        /// </value>
        public double BillAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        /// <value>
        /// The discount.
        /// </value>
        public double Discount { get; set; }

        /// <summary>
        /// Gets or sets the taxes.
        /// </summary>
        /// <value>
        /// The taxes.
        /// </value>
        public double Taxes { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        /// <value>
        /// The net amount.
        /// </value>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the supplier identifier.
        /// </summary>
        /// <value>
        /// The supplier identifier.
        /// </value>
        public int SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy purchase header identifier.
        /// </summary>
        /// <value>
        /// The pharmacy purchase header identifier.
        /// </value>
        public int InventoryPurchaseHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>
        public int InventoryWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        /// <value>
        /// The bill number.
        /// </value>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the type of the bill.
        /// </summary>
        /// <value>
        /// The type of the bill.
        /// </value>
        public string BillType { get; set; }

        /// <summary>
        /// Gets or sets the bill date.
        /// </summary>
        /// <value>
        /// The bill date.
        /// </value>
        public DateTime BillDate { get; set; }

        /// <summary>
        /// Gets or sets the products.
        /// </summary>
        /// <value>
        /// The products.
        /// </value>
        public List<InventoryBillDetailModel> Products { get; set; }

        /// <summary>
        /// Gets or sets the login role identifier.
        /// </summary>
        /// <value>
        /// The login role identifier.
        /// </value>
        public int LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the name of the inventory ware house.
        /// </summary>
        /// <value>
        /// The name of the inventory ware house.
        /// </value>
        public string InventoryWareHouseName { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the inventory purchase detail identifier.
        /// </summary>
        /// <value>
        /// The inventory purchase detail identifier.
        /// </value>
        public int? InventoryPurchaseDetailId { get; set; }
        /// <summary>
        /// Gets or sets the inventory purchase due date.
        /// </summary>
        /// <value>
        /// The inventory purchase due date.
        /// </value>
        public DateTime? DueDate { get; set; }
    }
}
