﻿namespace Hims.Shared.UserModels.Laboratory
{
    /// <summary>
    /// The lab daily report model.
    /// </summary>
    public class LabDailyReportModel
    {
        /// <summary>
        /// Gets or sets the lab name.
        /// </summary>
        public string LabName { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public double Amount { get; set; }

        /// <summary>
        /// Gets or sets the grand total.
        /// </summary>
        public double GrandTotal { get; set; }

        /// <summary>
        /// Gets or sets the doctor name.
        /// </summary>
        public string DoctorName { get; set; }

        /// <summary>
        /// Gets or sets the lab booking header id.
        /// </summary>
        public int LabBookingHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public System.DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the booking date.
        /// </summary>
        public System.DateTime BookingDate { get; set; }

        /// <summary>
        /// Gets or sets the discount amount. 
        /// </summary>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the net amount. 
        /// </summary>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        public int? DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the discount amount. 
        /// </summary>
        public double? OverallDiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the net amount. 
        /// </summary>
        public double OverallNetAmount { get; set; }

        /// <summary>
        /// Gets or sets the lab package id.
        /// </summary>
        public int? LabPackageId { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        public int? Age { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public string Gender { get; set; }

        /// <summary>
        /// Gets or sets the Payment Type.
        /// </summary>
        public string PayTypeName { get; set; }

        /// <summary>
        /// Gets or sets the department name.
        /// </summary>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the encrypted patient id.
        /// </summary>
        public string? EncryptedPatientId { get; set; }

        /// <summary>
        /// Gets or sets the Payment Number.
        /// </summary>
        public string PaymentNumber { get; set; }
    }
}
