﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels.Labs
{
    /// <summary>
    /// The LabDoctorVerificationModel.
    /// </summary>
    public class LabDoctorVerificationModel
    {
        /// <summary>
        /// Gets or sets the doctor identifier.
        /// </summary>
        /// <value>
        /// The doctor identifier.
        /// </value>
        public int DoctorId { get; set; }
        /// <summary>
        /// Creates new labbookingdetailid.
        /// </summary>
        /// <value>
        /// The new lab booking detail identifier.
        /// </value>
        public int NewLabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the account identifier.
        /// </summary>
        /// <value>
        /// The account identifier.
        /// </value>
        public int AccountId { get; set; }

        /// <summary>
        /// Gets or sets the URL link.
        /// </summary>
        /// <value>
        /// The URL link.
        /// </value>
        public string UrlLink { get; set; }

        /// <summary>
        /// Gets or sets the patient identifier.
        /// </summary>
        /// <value>
        /// The patient identifier.
        /// </value>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the role identifier.
        /// </summary>
        /// <value>
        /// The role identifier.
        /// </value>
        public int? RoleId { get; set; }

        /// <summary>
        /// Gets or sets the name of the test.
        /// </summary>
        /// <value>
        /// The name of the test.
        /// </value>
        public string TestName { get; set; }

        /// <summary>
        /// Gets or sets the requisition number.
        /// </summary>
        /// <value>
        /// The requisition number.
        /// </value>
        public string RequisitionNumber { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }
    }
}
