﻿namespace Hims.Shared.UserModels.PayU
{
    /// <summary>
    /// The payout model.
    /// </summary>
    public class PayoutModel
    {
        /// <summary>
        /// Gets or sets token
        /// </summary>
        public string Access_Token { get; set; }

        /// <summary>
        /// Gets or sets token type
        /// </summary>
        public string Token_Type { get; set; }

        /// <summary>
        /// Gets or sets Expires in
        /// </summary>
        public long? Expires_In { get; set; }

        /// <summary>
        /// Gets or sets refresh token
        /// </summary>
        public string Refresh_Token { get; set; }

        /// <summary>
        /// Gets or sets Scope
        /// </summary>
        public string Scope { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public decimal? Amount { get; set; }

        /// <summary>
        /// Gets or sets the merchant ref id.
        /// </summary>
        public string MerchantRefId { get; set; }

        /// <summary>
        /// Gets or sets the user name.
        /// </summary>
        public string UserName { get; set; }

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public string Email { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// Gets or sets the purpose.
        /// </summary>
        public string Purpose { get; set; }

        /// <summary>
        /// Gets or sets the batch id.
        /// </summary>
        public string BatchId { get; set; }

        /// <summary>
        /// Gets or sets the payment type.
        /// </summary>
        public string PaymentType { get; set; }

        /// <summary>
        /// Gets or sets the account number.
        /// </summary>
        public string AccountNumber { get; set; }

        /// <summary>
        /// Gets or sets the account number.
        /// </summary>
        public string IfscCode { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }
    }
}
