﻿#nullable enable
namespace Hims.Shared.UserModels.PediatricEncounter
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Hims.Shared.Library.Enums;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The encounter.
    /// </summary>
    public class InsertModel
    {
        /// <summary>
        /// Gets or sets the pediatric encounter id.
        /// </summary>
        public int PediatricEncounterId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int? AdmissionId { get; set; }
        /// <summary>
        /// Gets or sets the login role Id.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int LoginRoleId { get; set; }
        /// <summary>
        /// Gets or sets the encounter date.
        /// </summary>
        public DateTime PediatricEncounterDate { get; set; }
           /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get ; set; }
       
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the isadmission.
        /// </summary>
        public bool IsAdmission { get; set; }

        /// <summary>
        /// Gets or sets the json string.
        /// </summary>
        public string JsonString { get; set; }

        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public PediatricEncounterType Type { get; set; }

         /// <summary>
        /// Gets or sets the measurements.
        /// </summary>
        public string Measurements{ get; set; }
        /// <summary>
        /// Gets or sets the neonatalrisk.
        /// </summary>
        public string NeonatalRisk { get; set; }
        /// <summary>
        /// Gets or sets the pediatricrisk
        /// </summary>
        public string PediatricRisk { get; set; }
        /// <summary>
        /// Gets or sets the syndrome.
        /// </summary>
        public string Syndrome { get; set; }
        /// <summary>
        /// Gets or sets the syndrome.
        /// </summary>
        public string ClinicalExamination { get; set; }
        /// <summary>
        /// Gets or sets the syndrome.
        /// </summary>
        public string DownSyndromeFollowUp { get; set; }
        /// <summary>
        /// Gets or sets the high risk intial.
        /// </summary>
        public string HighRiskIntial { get; set; }
        /// <summary>
        /// Gets or sets the pediatric guide.
        /// </summary>
        public string PediatricGuide { get; set; }
        /// <summary>
        /// Gets or sets the pediatric guide.
        /// </summary>
        public string OrdersPrescription { get; set; }
        /// <summary>
        /// Gets or Sets ReferalOrder.
        /// </summary>
        public string? RefferalOrder { get; set; }
        /// <summary>
        /// Gets or Sets ReferalOrder.
        /// </summary>
        public string? DiagnosisOrder { get; set; }
        /// <summary>
        /// Gets or Sets ReferalOrder.
        /// </summary>
        public string? NextVisitOrder { get; set; }
        /// <summary>
        /// Gets or Sets SpecialFeatures.
        /// </summary>
        public string? SpecialFeatures { get; set; }
        
        /// <summary>
        /// Gets or Sets MChat
        /// </summary>
        public string? MChat { get; set; }

        public string CreatedByName { get; set; }

    }
}