﻿namespace Hims.Shared.UserModels.Pharmacy
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The new sales bill.
    /// </summary>
    public class NewSalesBill
    {
        /// <summary>
        /// Gets or sets the pharmacy sale header id.
        /// </summary>
        public int? PharmacySaleHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the appointment identifier.
        /// </summary>
        /// <value>
        /// The appointment identifier.
        /// </value>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the bill type.
        /// </summary>
        public string BillType { get; set; }

        /// <summary>
        /// Gets or sets the paid via.
        /// </summary>
        public string PaidVia { get; set; }

        /// <summary>
        /// Gets or sets the sale date.
        /// </summary>
        public DateTime SaleDate { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the login Account value id.
        /// </summary>
        public int? LoginAccountId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the login Role value id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the overall total.
        /// </summary>
        public double OverallTotal { get; set; }

        /// <summary>
        /// Gets or sets the overall net amount.
        /// </summary>
        public double OverallNetAmount { get; set; }

        /// <summary>
        /// Gets or sets the overall discount.
        /// </summary>
        public double? OverallDiscount { get; set; }

        /// <summary>
        /// Gets or sets the overall tax.
        /// </summary>
        public double OverallTax { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the Payment number.
        /// </summary>
        public string PaymentNumber { get; set; }

        /// <summary>
        /// Gets or sets the products.
        /// </summary>
        public List<NewSaleBillProductModel> Products { get; set; }

        /// <summary>
        /// Gets or sets the Specialization Id.
        /// </summary>
        public int? SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double? TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string TransactionId { get; set; }

        /// <summary>
        /// Gets or sets the transaction.
        /// </summary>
        public string Transaction { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public int? SalucroStatusCode { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string SalucroTransactionId { get; set; }

        /// <summary>
        /// Gets or sets the Payment status.
        /// </summary>
        public bool PaymentStatus { get; set; }

        /// <summary>
        /// Gets or sets the payment initiation log identifier.
        /// </summary>
        /// <value>
        /// The payment initiation log identifier.
        /// </value>
        public int? PaymentInitiationLogId { get; set; }

        /// <summary>
        /// Gets or sets the is salucro bill.
        /// </summary>
        public bool IsSalucroBill { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string ProductList { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string TypeOfPayment { get; set; }
        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string ReasonForDiscount { get; set; }
    }

    /// <summary>
    /// The new sale bill product model.
    /// </summary>
    public class NewSaleBillProductModel
    {
        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy retail stock id.
        /// </summary>
        public int PharmacyRetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the mrp.
        /// </summary>
        public double? Mrp { get; set; }

        /// <summary>
        /// Gets or sets the tax percentage.
        /// </summary>
        public string TaxPercentage { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double? Total { get; set; }

        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        public double? TaxAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount per item.
        /// </summary>
        public double? DiscountPerItem { get; set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        public double? Discount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double? NetAmount { get; set; }
        
    }
}
