﻿namespace Hims.Shared.UserModels
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The supplier product model.
    /// </summary>
    public class SupplierProductModel
    {
        /// <summary>
        /// Gets or sets the supplier product id.
        /// </summary>
        public int SupplierProductId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the supplier id.
        /// </summary>
        public int SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        public double? PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the MRP.
        /// </summary>
        /// <value>
        /// The MRP.
        /// </value>
        public double? Mrp { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the products.
        /// </summary>
        /// <value>
        /// The products.
        /// </value>
        public List<SupplierProductInsertionModel> Products { get; set; }
    }


    public class SupplierProductInsertionModel
    {

        /// <summary>
        /// Gets or sets the supplier product id.
        /// </summary>
        public int? SupplierProductId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        /// <value>
        /// The purchase rate.
        /// </value>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the MRP.
        /// </summary>
        /// <value>
        /// The MRP.
        /// </value>
        public double Mrp { get; set; }
    }
}
