﻿namespace Hims.Shared.UserModels
{
    /// <summary>
    /// The telemedicine appointment model.
    /// </summary>
    public class TelemedicineAppointmentModel
    {
        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public string EncounterType { get; set; }

        /// <summary>
        /// Gets or sets the encrypted appointment id.
        /// </summary>
        public string EncryptedAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the patient full name.
        /// </summary>
        public string PatientFullName { get; set; }

        /// <summary>
        /// Gets or sets the patient first name.
        /// </summary>
        public string PatientFirstName { get; set; }

        /// <summary>
        /// Gets or sets the provider full name.
        /// </summary>
        public string ProviderFullName { get; set; }

        /// <summary>
        /// Gets or sets the provider first name.
        /// </summary>
        public string ProviderFirstName { get; set; }
        public int ProviderAccountId { get; set; }
        public int PatientAccountId { get; set; }
    }
}