﻿namespace Hims.Domain.Entities
{
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The pharmacy purchase detail.
    /// </summary>
    public class PharmacyPurchaseDetail
    {
        /// <summary>
        /// Gets or sets the pharmacy purchase detail id.
        /// </summary>
        [Key, Identity]
        public int PharmacyPurchaseDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy purchase header id.
        /// </summary>
        public int PharmacyPurchaseHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the purchase order detail identifier.
        /// </summary>
        /// <value>
        /// The purchase order detail identifier.
        /// </value>
        public long? PurchaseOrderDetailId { get; set; }

        /// <summary>
        /// Gets or sets the serial num.
        /// </summary>
        public int SerialNum { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the free.
        /// </summary>
        public int Free { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the mrp.
        /// </summary>
        public double Mrp { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the tax per item.
        /// </summary>
        public double TaxPerItem { get; set; }

        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        public double TaxAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount per item.
        /// </summary>
        public double DiscountPerItem { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        public double DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the barcode.
        /// </summary>
        public string Barcode { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy stock id.
        /// </summary>
        public int? PharmacyStockId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy retail stock id.
        /// </summary>
        public int? PharmacyRetailStockId { get; set; }
    }
}
