﻿namespace Hims.Domain.Entities.Vaccine
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The vaccine master.
    /// </summary>
    public class VaccineMaster
    {
        /// <summary>
        /// Gets or sets the vaccine master identifier.
        /// </summary>
        /// <value>
        /// The vaccine master identifier.
        /// </value>
        [Key,Identity]
        public int VaccineMasterId { get; set; }

        /// <summary>
        /// Gets or sets the vaccine group identifier.
        /// </summary>
        /// <value>
        /// The vaccine group identifier.
        /// </value>
        public int VaccineGroupId { get; set; }

        /// <summary>
        /// Gets or sets the name of the vaccine.
        /// </summary>
        /// <value>
        /// The name of the vaccine.
        /// </value>
        public string VaccineName { get; set; }

        /// <summary>
        /// Gets or sets the display name.
        /// </summary>
        /// <value>
        /// The display name.
        /// </value>
        public string DisplayName { get; set; }

        /// <summary>
        /// Gets or sets the vaccine instruction.
        /// </summary>
        /// <value>
        /// The vaccine instruction.
        /// </value>
        public string VaccineInstruction { get; set; }

        /// <summary>
        /// Gets or sets the order.
        /// </summary>
        /// <value>
        /// The order.
        /// </value>
        public int Order { get; set; }

        /// <summary>
        /// Gets or sets the vaaccine type identifier.
        /// </summary>
        /// <value>
        /// The vaaccine type identifier.
        /// </value>
        public int VaccineTypeId { get; set; }

        /// <summary>
        /// Gets or sets the allowed days.
        /// </summary>
        /// <value>
        /// The allowed days.
        /// </value>
        public double AllowedDays { get; set; }

        /// <summary>
        /// Gets or sets the type of the allowed.
        /// </summary>
        /// <value>
        /// The type of the allowed.
        /// </value>
        public string AllowedType { get; set; }

        /// <summary>
        /// Gets or sets the exclusion days.
        /// </summary>
        /// <value>
        /// The exclusion days.
        /// </value>
        public string ExclusionDays { get; set; }

        /// <summary>
        /// Gets or sets the allowed laps days.
        /// </summary>
        /// <value>
        /// The allowed laps days.
        /// </value>
        public int? AllowedLapsDays { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="VaccineMaster"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the vaccine age group identifier.
        /// </summary>
        /// <value>
        /// The vaccine age group identifier.
        /// </value>
        public int VaccineAgeGroupId { get; set; }
    }
}
