﻿namespace Hims.Domain.Services
{
    using System.Threading.Tasks;
    using Shared.EntityModels;

    /// <summary>
    /// The Appointment log Service interface.
    /// </summary>
    public interface IAppointmentLogService
    {
        /// <summary>
        /// The find async.
        /// </summary>
        /// <param name="appointmentLogId">
        /// The appointment log id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<AppointmentLogModel> FindAsync(int appointmentLogId);

        /// <summary>
        /// The modify async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(AppointmentLogModel model);

        /// <summary>
        /// The delete async.
        /// </summary>
        /// <param name="appointmentLogId">
        /// The appointment log Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int appointmentLogId);
    }
}