﻿namespace Hims.Shared.EntityModels
{
    using System;
    using System.Collections.Generic;
    using System.Text;

    /// <summary>
    /// The inventory stock model.
    /// </summary>
    public class InventoryStockModel
    {
        /// <summary>
        /// Gets or sets the inventory stock id.
        /// </summary>
        public int InventoryStockId { get; set; }

        /// <summary>
        /// Gets or sets the department id.
        /// </summary>
        public int? DepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the inventory product id.
        /// </summary>
        public int? InventoryProductId { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the quantity in.
        /// </summary>
        public int QuantityIn { get; set; }

        /// <summary>
        /// Gets or sets the quantity out.
        /// </summary>
        public int QuantityOut { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the category name.
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the tax percentage.
        /// </summary>
        public string TaxPercentage { get; set; }

        /// <summary>
        /// Gets or sets the available qty.
        /// </summary>
        public int AvailableQty { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        public double? DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the login account id.
        /// </summary>
        public int? LoginAccountId { get; set; }

        /// <summary>
        /// Gets or sets the login role id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the inventory ware house identifier.
        /// </summary>
        /// <value>
        /// The inventory ware house identifier.
        /// </value>
        public int? InventoryWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the modified name.
        /// </summary>
        public string ModifiedName { get; set; }

        /// <summary>
        /// Gets or sets the bulk product ids.
        /// </summary>
        /// <value>
        /// The bulk product ids.
        /// </value>
        public string BulkProductIds { get; set; }

        /// <summary>
        /// Gets or sets the name of the rack.
        /// </summary>
        /// <value>
        /// The name of the rack.
        /// </value>
        public string RackName { get; set; }

        /// <summary>
        /// Gets or sets the inventory product detail identifier.
        /// </summary>
        /// <value>
        /// The inventory product detail identifier.
        /// </value>
        public int? InventoryProductDetailId { get; set; }

        /// <summary>
        /// Gets or sets the roq.
        /// </summary>
        /// <value>
        /// The roq.
        /// </value>
        public int? ROQ { get; set; }

        /// <summary>
        /// Gets or sets the rol.
        /// </summary>
        /// <value>
        /// The rol.
        /// </value>
        public int? ROL { get; set; }
    }
}
